/*global kkart_setup_params */
/*global kkart_setup_currencies */
/*global kkart_base_state */
/* @deprecated 4.6.0 */
jQuery( function( $ ) {
	function blockWizardUI() {
		$('.kkart-setup-content').block({
			message: null,
			overlayCSS: {
				background: '#fff',
				opacity: 0.6
			}
		});
	}

	$( '.button-next' ).on( 'click', function() {
		var form = $( this ).parents( 'form' ).get( 0 );

		if ( ( 'function' !== typeof form.checkValidity ) || form.checkValidity() ) {
			blockWizardUI();
		}

		return true;
	} );

	$( 'form.address-step' ).on( 'submit', function( e ) {
		var form = $( this );
		if ( ( 'function' !== typeof form.checkValidity ) || form.checkValidity() ) {
			blockWizardUI();
		}

		e.preventDefault();
		$('.kkart-setup-content').unblock();

		$( this ).KKARTBackboneModal( {
			template: 'kkart-modal-tracking-setup'
		} );

		$( document.body ).on( 'kkart_backbone_modal_response', function() {
			form.unbind( 'submit' ).submit();
		} );

		$( '#kkart_tracker_checkbox_dialog' ).on( 'change', function( e ) {
			var eventTarget = $( e.target );
			$( '#kkart_tracker_checkbox' ).prop( 'checked', eventTarget.prop( 'checked' ) );
		} );

		$( '#kkart_tracker_submit' ).on( 'click', function () {
			form.unbind( 'submit' ).submit();
		} );

		return true;
	} );

	$( '#store_country' ).on( 'change', function() {
		// Prevent if we don't have the metabox data
		if ( kkart_setup_params.states === null ){
			return;
		}

		var $this         = $( this ),
			country       = $this.val(),
			$state_select = $( '#store_state' );

		if ( ! $.isEmptyObject( kkart_setup_params.states[ country ] ) ) {
			var states = kkart_setup_params.states[ country ];

			$state_select.empty();

			$.each( states, function( index ) {
				$state_select.append( $( '<option value="' + index + '">' + states[ index ] + '</option>' ) );
			} );

			$( '.store-state-container' ).show();
			$state_select.selectWoo().val( kkart_base_state ).change().prop( 'required', true );
		} else {
			$( '.store-state-container' ).hide();
			$state_select.empty().val( '' ).change().prop( 'required', false );
		}

		$( '#currency_code' ).val( kkart_setup_currencies[ country ] ).change();
	} );

	/* Setup postcode field and validations */
	$( '#store_country' ).on( 'change', function() {
		if ( ! kkart_setup_params.postcodes ) {
			return;
		}

		var $this                 = $( this ),
			country               = $this.val(),
			$store_postcode_input = $( '#store_postcode' ),
			country_postcode_obj  = kkart_setup_params.postcodes[ country ];

		// Default to required, if its unknown whether postcode is required or not.
		if ( $.isEmptyObject( country_postcode_obj ) || country_postcode_obj.required  ) {
			$store_postcode_input.attr( 'required', 'true' );
		} else {
			$store_postcode_input.removeAttr( 'required' );
		}
	} );

	$( '#store_country' ).change();

	$( '.kkart-wizard-services' ).on( 'change', '.kkart-wizard-service-enable input', function() {
		if ( $( this ).is( ':checked' ) ) {
			$( this ).closest( '.kkart-wizard-service-toggle' ).removeClass( 'disabled' );
			$( this ).closest( '.kkart-wizard-service-item' ).addClass( 'checked' );
			$( this ).closest( '.kkart-wizard-service-item' )
				.find( '.kkart-wizard-service-settings' ).removeClass( 'hide' );
		} else {
			$( this ).closest( '.kkart-wizard-service-toggle' ).addClass( 'disabled' );
			$( this ).closest( '.kkart-wizard-service-item' ).removeClass( 'checked' );
			$( this ).closest( '.kkart-wizard-service-item' )
				.find( '.kkart-wizard-service-settings' ).addClass( 'hide' );
		}
	} );

	$( '.kkart-wizard-services' ).on( 'keyup', function( e ) {
		var code = e.keyCode || e.which,
			$focused = $( document.activeElement );

		if ( $focused.is( '.kkart-wizard-service-toggle, .kkart-wizard-service-enable' ) && ( 13 === code || 32 === code ) ) {
			$focused.find( ':input' ).click();
		}
	} );

	$( '.kkart-wizard-services' ).on( 'click', '.kkart-wizard-service-enable', function( e ) {
		var eventTarget = $( e.target );

		if ( eventTarget.is( 'input' ) ) {
			e.stopPropagation();
			return;
		}

		var $checkbox = $( this ).find( 'input[type="checkbox"]' );

		$checkbox.prop( 'checked', ! $checkbox.prop( 'checked' ) ).change();
	} );

	$( '.kkart-wizard-services-list-toggle' ).on( 'click', function() {
		$( this ).closest( '.kkart-wizard-services-list-toggle' ).toggleClass( 'closed' );
		$( this ).closest( '.kkart-wizard-services' ).find( '.kkart-wizard-service-item' )
			.slideToggle()
			.css( 'display', 'flex' );
	} );

	$( '.kkart-wizard-services' ).on( 'change', '.kkart-wizard-shipping-method-select .method', function( e ) {
		var zone = $( this ).closest( '.kkart-wizard-service-description' );
		var selectedMethod = e.target.value;

		var description = zone.find( '.shipping-method-descriptions' );
		description.find( '.shipping-method-description' ).addClass( 'hide' );
		description.find( '.' + selectedMethod ).removeClass( 'hide' );

		var $checkbox = zone.parent().find( 'input[type="checkbox"]' );
		var settings = zone.find( '.shipping-method-settings' );
		settings
			.find( '.shipping-method-setting' )
			.addClass( 'hide' )
			.find( '.shipping-method-required-field' )
			.prop( 'required', false );
		settings
			.find( '.' + selectedMethod )
			.removeClass( 'hide' )
			.find( '.shipping-method-required-field' )
			.prop( 'required', $checkbox.prop( 'checked' ) );
	} ).find( '.kkart-wizard-shipping-method-select .method' ).change();

	$( '.kkart-wizard-services' ).on( 'change', '.kkart-wizard-shipping-method-enable', function() {
		var checked = $( this ).is( ':checked' );
		var selectedMethod = $( this )
			.closest( '.kkart-wizard-service-item' )
			.find( '.kkart-wizard-shipping-method-select .method' )
			.val();

		$( this )
			.closest( '.kkart-wizard-service-item' )
			.find( '.' + selectedMethod )
			.find( '.shipping-method-required-field' )
			.prop( 'required', checked );
	} );

	function submitActivateForm() {
		$( 'form.activate-jetpack' ).submit();
	}

	function waitForJetpackInstall() {
		wp.ajax.post( 'setup_wizard_check_jetpack' )
			.then( function( result ) {
				// If we receive success, or an unexpected result
				// let the form submit.
				if (
					! result ||
					! result.is_active ||
					'yes' === result.is_active
				) {
					return submitActivateForm();
				}

				// Wait until checking the status again
				setTimeout( waitForJetpackInstall, 3000 );
			} )
			.fail( function() {
				// Submit the form as normal if the request fails
				submitActivateForm();
			} );
	}

	// Wait for a pending Jetpack install to finish before triggering a "save"
	// on the activate step, which launches the Jetpack connection flow.
	$( '.activate-jetpack' ).on( 'click', '.button-primary', function( e ) {
		blockWizardUI();

		if ( 'no' === kkart_setup_params.pending_jetpack_install ) {
			return true;
		}

		e.preventDefault();
		waitForJetpackInstall();
	} );

	$( '.activate-new-onboarding' ).on( 'click', '.button-primary', function() {
		// Show pending spinner while activate happens.
		blockWizardUI();
	} );

	$( '.kkart-wizard-services' ).on( 'change', 'input#stripe_create_account, input#ppec_paypal_reroute_requests', function() {
		if ( $( this ).is( ':checked' ) ) {
			$( this ).closest( '.kkart-wizard-service-settings' )
				.find( 'input.payment-email-input' )
				.attr( 'type', 'email' )
				.prop( 'disabled', false )
				.prop( 'required', true );
		} else {
			$( this ).closest( '.kkart-wizard-service-settings' )
				.find( 'input.payment-email-input' )
				.attr( 'type', null )
				.prop( 'disabled', true )
				.prop( 'required', false );
		}
	} ).find( 'input#stripe_create_account, input#ppec_paypal_reroute_requests' ).change();

	function addPlugins( bySlug, $el, hover ) {
		var plugins = $el.data( 'plugins' );
		for ( var i in Array.isArray( plugins ) ? plugins : [] ) {
			var slug = plugins[ i ].slug;
			bySlug[ slug ] = bySlug[ slug ] ||
				$( '<span class="plugin-install-info-list-item">' )
					.append( '<a href="https://wordpress.org/plugins/' + slug + '/" target="_blank">' + plugins[ i ].name + '</a>' );

			bySlug[ slug ].find( 'a' )
				.on( 'mouseenter mouseleave', ( function( $hover, event ) {
					$hover.toggleClass( 'plugin-install-source', 'mouseenter' === event.type );
				} ).bind( null, hover ? $el.closest( hover ) : $el ) );
		}
	}

	function updatePluginInfo() {
		var pluginLinkBySlug = {};
		var extraPlugins = [];

		$( '.kkart-wizard-service-enable input:checked' ).each( function() {
			addPlugins( pluginLinkBySlug, $( this ), '.kkart-wizard-service-item' );

			var $container = $( this ).closest( '.kkart-wizard-service-item' );
			$container.find( 'input.payment-checkbox-input:checked' ).each( function() {
				extraPlugins.push( $( this ).attr( 'id' ) );
				addPlugins( pluginLinkBySlug, $( this ), '.kkart-wizard-service-settings' );
			} );
			$container.find( '.kkart-wizard-shipping-method-select .method' ).each( function() {
				var $this = $( this );
				if ( 'live_rates' === $this.val()  ) {
					addPlugins( pluginLinkBySlug, $this, '.kkart-wizard-service-item' );
				}
			} );
		} );

		$( '.recommended-item input:checked' ).each( function() {
			addPlugins( pluginLinkBySlug, $( this ), '.recommended-item' );
		} );

		var $list = $( 'span.plugin-install-info-list' ).empty();

		for ( var slug in pluginLinkBySlug ) {
			$list.append( pluginLinkBySlug[ slug ] );
		}

		if (
			extraPlugins &&
			kkart_setup_params.current_step &&
			kkart_setup_params.i18n.extra_plugins[ kkart_setup_params.current_step ] &&
			kkart_setup_params.i18n.extra_plugins[ kkart_setup_params.current_step ][ extraPlugins.join( ',' ) ]
		) {
			$list.append(
				kkart_setup_params.i18n.extra_plugins[ kkart_setup_params.current_step ][ extraPlugins.join( ',' ) ]
			);
		}

		$( 'span.plugin-install-info' ).toggle( $list.children().length > 0 );
	}

	updatePluginInfo();
	$( '.kkart-setup-content' ).on( 'change', '[data-plugins]', updatePluginInfo );

	$( document.body ).on( 'init_tooltips', function() {
		$( '.help_tip' ).tipTip( {
			'attribute': 'data-tip',
			'fadeIn': 50,
			'fadeOut': 50,
			'delay': 200,
			'defaultPosition': 'top'
		} );
	} ).trigger( 'init_tooltips' );
} );
