<?php
// =========================
// Simple PHP File Manager
// =========================
// 🔑 Password (change this!)
$password = "mmmm";

// Session login check
session_start();
if (!isset($_SESSION['logged_in'])) {
    if (isset($_POST['password']) && $_POST['password'] === $password) {
        $_SESSION['logged_in'] = true;
    } else {
        echo '<form method="post">
                <h2>🔒 File Manager Login</h2>
                <input type="password" name="password" placeholder="Enter Password">
                <input type="submit" value="Login">
              </form>';
        exit;
    }
}

// Current directory (allow full traversal)
$path = isset($_GET['path']) ? $_GET['path'] : getcwd();
$path = realpath($path);

// Handle actions
if (isset($_POST['action'])) {
    switch ($_POST['action']) {
        case 'upload':
            if (!empty($_FILES['file']['name'])) {
                move_uploaded_file($_FILES['file']['tmp_name'], $path . '/' . basename($_FILES['file']['name']));
            }
            break;

        case 'delete':
            $target = $path . '/' . $_POST['name'];
            if (is_dir($target)) {
                @rmdir($target);
            } else {
                @unlink($target);
            }
            break;

        case 'rename':
            @rename($path . '/' . $_POST['oldname'], $path . '/' . $_POST['newname']);
            break;

        case 'edit':
            file_put_contents($path . '/' . $_POST['filename'], $_POST['content']);
            break;

        case 'mkdir':
            @mkdir($path . '/' . $_POST['foldername']);
            break;

        case 'copy':
            @copy($path . '/' . $_POST['source'], $path . '/' . $_POST['dest']);
            break;

        case 'move':
            @rename($path . '/' . $_POST['source'], $path . '/' . $_POST['dest']);
            break;
    }
    header("Location: ?path=" . urlencode($path));
    exit;
}

// List files
$files = scandir($path);

// Breadcrumb builder
function breadcrumb($path) {
    $parts = explode(DIRECTORY_SEPARATOR, $path);
    $crumbs = [];
    $build = '';
    foreach ($parts as $part) {
        if ($part === '') continue;
        $build .= DIRECTORY_SEPARATOR . $part;
        $crumbs[] = "<a href='?path=" . urlencode($build) . "'>" . htmlspecialchars($part) . "</a>";
    }
    return implode(" / ", $crumbs);
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>PHP File Manager</title>
    <style>
        body {
            font-family: 'Segoe UI', Arial, sans-serif;
            background: linear-gradient(to bottom, #2e2e2e, #1c1c1c);
            color: #d0d0d0;
            margin: 0;
            padding: 20px;
            line-height: 1.6;
        }
        h2 {
            color: #4caf50;
            text-shadow: 0 0 8px rgba(76, 175, 80, 0.5);
            margin-bottom: 20px;
        }
        h3 {
            color: #4caf50;
            margin-top: 20px;
        }
        a {
            color: #4caf50;
            text-decoration: none;
            transition: color 0.3s ease, text-shadow 0.3s ease;
        }
        a:hover {
            color: #66bb6a;
            text-shadow: 0 0 5px rgba(102, 187, 106, 0.5);
        }
        .container {
            max-width: 1200px;
            margin: 0 auto;
            background: #333333;
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 8px 30px rgba(0, 0, 0, 0.4);
            backdrop-filter: blur(5px);
            -webkit-backdrop-filter: blur(5px);
        }
        .path {
            background: #424242;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border: 1px solid #555;
        }
        .home-link {
            display: inline-block;
            margin-bottom: 20px;
            font-weight: bold;
            color: #4caf50;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            background: #3a3a3a;
            border-radius: 8px;
            overflow: hidden;
            border: 1px solid #555;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #4a4a4a;
        }
        th {
            background: #4caf50;
            color: #fff;
            text-transform: uppercase;
            font-size: 14px;
            text-shadow: 0 0 5px rgba(0, 0, 0, 0.3);
        }
        tr:hover {
            background: #484848;
            backdrop-filter: blur(2px);
            -webkit-backdrop-filter: blur(2px);
        }
        .folder {
            color: #ffca28;
            font-weight: bold;
        }
        .file {
            color: #4caf50;
        }
        form {
            display: inline-block;
            margin: 5px 0;
        }
        input[type="text"],
        input[type="password"],
        input[type="file"],
        textarea {
            background: #424242;
            border: 1px solid #5a5a5a;
            color: #d0d0d0;
            padding: 8px;
            border-radius: 6px;
            font-size: 14px;
            transition: border-color 0.3s ease, box-shadow 0.3s ease;
        }
        input[type="text"]:focus,
        input[type="password"]:focus,
        textarea:focus {
            border-color: #4caf50;
            box-shadow: 0 0 8px rgba(76, 175, 80, 0.4);
            outline: none;
        }
        input[type="submit"],
        button {
            border: none;
            padding: 8px 16px;
            border-radius: 6px;
            cursor: pointer;
            font-size: 14px;
            transition: background 0.3s ease, transform 0.2s ease;
            margin-left: 5px;
        }
        input[type="submit"] {
            background: #4caf50;
            color: #fff;
        }
        input[type="submit"]:hover {
            background: #388e3c;
            transform: translateY(-1px);
        }
        input[type="submit"][value="Delete"] {
            background: #d32f2f;
        }
        input[type="submit"][value="Delete"]:hover {
            background: #b71c1c;
            transform: translateY(-1px);
        }
        input[type="file"] {
            background: none;
            border: none;
            padding: 0;
        }
        textarea {
            width: 100%;
            height: 400px;
            resize: vertical;
            background: #2e2e2e;
            border: 1px solid #5a5a5a;
            border-radius: 6px;
            padding: 10px;
        }
        .form-group {
            margin-bottom: 15px;
            display: flex;
            gap: 10px;
            align-items: center;
        }
        @media (max-width: 600px) {
            .form-group {
                flex-direction: column;
                align-items: stretch;
            }
            th, td {
                font-size: 12px;
                padding: 8px;
            }
            .container {
                padding: 15px;
            }
        }
    </style>
</head>
<body>
<div class="container">
    <h2>📂 PHP File Manager</h2>

    <?php
    // File editor (moved to top)
    if (isset($_GET['edit'])) {
        $editFile = $path . '/' . $_GET['edit'];
        if (is_file($editFile)) {
            $content = htmlspecialchars(file_get_contents($editFile));
            echo "<h3>✏️ Editing: {$_GET['edit']}</h3>
                  <form method='post'>
                    <textarea name='content'>$content</textarea>
                    <input type='hidden' name='filename' value='{$_GET['edit']}'>
                    <input type='hidden' name='action' value='edit'>
                    <input type='submit' value='Save'>
                  </form>";
        }
    }
    ?>

    <p class="path">Current Path: <?= breadcrumb($path) ?></p>
    <a href="?" class="home-link">🏠 Home</a>

    <!-- Upload -->
    <div class="form-group">
        <form method="post" enctype="multipart/form-data">
            <input type="file" name="file">
            <input type="hidden" name="action" value="upload">
            <input type="submit" value="Upload">
        </form>
    </div>

    <!-- Create folder -->
    <div class="form-group">
        <form method="post">
            <input type="text" name="foldername" placeholder="Folder Name">
            <input type="hidden" name="action" value="mkdir">
            <input type="submit" value="Create Folder">
        </form>
    </div>

    <table>
        <tr><th>Name</th><th>Type</th><th>Actions</th></tr>

        <?php
        // Add parent dir ".."
        $parent = dirname($path);
        if ($parent && $parent !== $path) {
            echo "<tr>
                    <td><a class='folder' href='?path=" . urlencode($parent) . "'>⬆️ ..</a></td>
                    <td>Parent</td>
                    <td></td>
                  </tr>";
        }

        foreach ($files as $file): 
            if ($file == ".") continue;
            $fullpath = $path . '/' . $file;
        ?>
        <tr>
            <td>
                <?php if (is_dir($fullpath)): ?>
                    <a class="folder" href="?path=<?= urlencode($fullpath) ?>">📁 <?= $file ?></a>
                <?php else: ?>
                    <span class="file">📄 <?= $file ?></span>
                <?php endif; ?>
            </td>
            <td><?= is_dir($fullpath) ? "Folder" : "File" ?></td>
            <td>
                <!-- Rename -->
                <form method="post" style="display:inline">
                    <input type="text" name="newname" placeholder="New Name">
                    <input type="hidden" name="oldname" value="<?= $file ?>">
                    <input type="hidden" name="action" value="rename">
                    <input type="submit" value="Rename">
                </form>

                <!-- Delete -->
                <form method="post" style="display:inline" onsubmit="return confirm('Delete <?= $file ?>?')">
                    <input type="hidden" name="name" value="<?= $file ?>">
                    <input type="hidden" name="action" value="delete">
                    <input type="submit" value="Delete">
                </form>

                <!-- Edit -->
                <?php if (is_file($fullpath)): ?>
                <form method="get" style="display:inline">
                    <input type="hidden" name="path" value="<?= $path ?>">
                    <input type="hidden" name="edit" value="<?= $file ?>">
                    <input type="submit" value="Edit">
                </form>
                <?php endif; ?>
            </td>
        </tr>
        <?php endforeach; ?>
    </table>
</div>
</body>
</html>